// Exp-14 : Design High Pass Filter as per the given specification and plot the Frequency Response.

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7

clc;
close;
clear;
delta1=0.1;
delta2=0.1;
fl=2;
fh=2.115;
fs=8;
A=-20*log10(min(delta1:delta2));
w1=2*3.14*fl/fs;
w2=2*3.14*fh/fs;
temp=1+((A-8)/(2.285*((2*3.14*fh/fs)-(2*3.14*fl/fs))));
N=ceil((temp-1)/2);
n=-N:N;
del=[zeros(1:N) 1 zeros(N+1:2*N)];
h=del-(((w2+w1)/2)*(sinc(((w2+w1)/2)*n)))/(3.14);   // High_Pass=1-Low_Pass
//h=[-h(1:30) 0 -h(32:61)];
//figure;
//plot(n,h);

[xmh,frh]=frmag(h,8000);
figure;
plot(frh,xmh);
title('Frequency Response','color','red','fontsize', 4);
xlabel("Frequency (Normalized)", "fontsize", 2,"color", "blue");
ylabel("Magnitude", "fontsize", 2, "color", "blue");
